export default function updateSummary() {
  const shipmentOptions = document.querySelectorAll('.input-shipping-method');
  Array.from(shipmentOptions).forEach((shipmentOption) => {
    shipmentOption.addEventListener('change', () => {
      const orderSummary = document.querySelector('.checkout-sidebar');
      fetch(shipmentOption.dataset.summaryUrl, {
        method: 'GET',
      }).then((result) => {
        if (result.status === 200) {
          return result.json();
        }
        throw new Error('Shipment_order_updater return non 200 code');
      }).then((result) => {
        orderSummary.innerHTML = result.view;
      });
    });
  });
}
