const pickupPoints = {
    pickupPointShippingMethods: document.querySelectorAll('input.input-shipping-method[data-pickup-point-provider]'),
    pickupPointsField: document.querySelectorAll('div.dedi-sylius-shipment-pickup-point-field')[0],
    pickupPointsFieldInput: document.querySelectorAll('div.dedi-sylius-shipment-pickup-point-field input.dedi-sylius-shipment-pickup-point-field-input')[0],
    pickupPointsFieldChoices: document.querySelectorAll('.dedi-sylius-shipment-pickup-point-field-choices')[0],
    pickupPointsFieldChoicePrototype: document.querySelectorAll('.dedi-sylius-shipment-pickup-point-field-choice-prototype')[0],
    shippingMethods: document.querySelectorAll('input.input-shipping-method'),
    pickupPointChoices: {},
    lastChosenPickupPointId: null,
    init: function (args) {
        const that = this;
        this.searchUrl = args.searchUrl;
        if (0 === this.pickupPointShippingMethods.length) {
            return;
        }
        this.pickupPointsField.style.display = 'block';

        let pickupPointChoices = this.pickupPointChoices;
        let promises = Array.from(this.pickupPointShippingMethods).map(function (element) {
            let shippingMethodCode = element.value;
            that.pickupPointChoices[shippingMethodCode] = {};
            return that.searchPickupPoints(element)
                .then((result) => {
                    if (result.status === 200) {
                        return result.json();
                    }
                    throw new Error('search pickup points return non 200 code');
                })
                .then((result) => {
                    pickupPointChoices[shippingMethodCode] = JSON.parse(result);
                })
            ;
        });

        this.pickupPointChoices = pickupPointChoices;

        this.shippingMethods.forEach((element) => {
            element.addEventListener('change', () => {
                if (0 !== this.pickupPointsFieldInput.value.length) {
                    this.lastChosenPickupPointId = this.pickupPointsFieldInput.value;
                }
                this.pickupPointsFieldInput.value = null;
                this.render();
            });
        });

        Promise.all(promises).then(function() {
            that.render();
        });
    },
    searchPickupPoints: function (input) {
        let inputSearchUrl = this.searchUrl;
        inputSearchUrl = inputSearchUrl.replace('{providerCode}', input.getAttribute('data-pickup-point-provider'));
        inputSearchUrl = inputSearchUrl.replace('{_csrf_token}', input.getAttribute('data-csrf-token'));

        return fetch(inputSearchUrl, {
            method: 'GET',
            headers: {
                "Content-Type": "application/json",
            },
        })
    },
    render: function () {
        let selectedElement = document.querySelectorAll('input.input-shipping-method:checked');
        selectedElement = selectedElement[0];
        let currentShippingMethodCode = selectedElement.value;

        const values = this.pickupPointChoices[currentShippingMethodCode];
        if ('undefined' === typeof values || 'undefined' === typeof values.length || 0 === values.length) {
            this.pickupPointsField.style.display = 'none';
            this.pickupPointsFieldChoices.innerHTML = '';
            return;
        }

        this.pickupPointsField.style.display = 'block';
        this.pickupPointsFieldChoices.innerHTML = this.valuesToRadio(values);

        var currentPickupPointId = this.pickupPointsFieldInput.value;
        if (null === currentPickupPointId || 0 === currentPickupPointId.length) {
            currentPickupPointId = this.lastChosenPickupPointId;
        }

        var currentPickupPointRadio = document.querySelector(`input.dedi-sylius-shipment-pickup-point-field-choice-field[value="${currentPickupPointId}"]`);
        if (null !== currentPickupPointRadio) {
            currentPickupPointRadio.checked = true;
        }

        const choices = document.querySelectorAll('input.dedi-sylius-shipment-pickup-point-field-choice-field');
        choices.forEach((choice) => {
            choice.addEventListener('change', () => {
                this.pickupPointsFieldInput.value = choice.getAttribute('value');
            });
        });
    },
    valuesToRadio(values) {
        let content = ``;

        values.forEach((value) => {
            let prototype = this.pickupPointsFieldChoicePrototype.innerHTML;
            let radio = prototype.replace(/{code}/g, value.code);
            radio = radio.replace(/{name}/g, value.name);
            radio = radio.replace(/{full_address}/g, value.full_address);
            radio = radio.replace(/{latitude}/g, value.latitude);
            radio = radio.replace(/{longitude}/g, value.longitude);

            content += radio;
        });

        return content;
    },
};

export default pickupPoints;