<p align="center">
    <a href="https://sylius.com" target="_blank">
        <img src="https://demo.sylius.com/assets/shop/img/logo.png" />
    </a>
</p>

<p align="center">
    <a href="https://sylius.com" target="_blank">
        <img src="https://www.dedi-agency.com/wp-content/uploads/2014/05/Dedi_logo_HD.png" />
    </a>
</p>

## Dedi Shipment Plugin

## Quickstart Installation
###Install the plugin
```bash
composer require dedi/sylius-shipment-plugin
```

### Add plugin to your bundle.php
```php
<?php
$bundles = [
    // ...
    Dedi\SyliusShipmentPlugin\DediSyliusShipmentPlugin::class => ['all' => true],
    // ...
];
```

### Import plugin configuration
```yaml
# config/packages/dedi_sylius_shipment_plugin.yaml
imports:
  - { resource: "@DediSyliusShipmentPlugin/config/config.yaml" }
```

### Import routing
```yaml
# config/routes/dedi_sylius_shipment_plugin.yaml
dedi_sylius_shipment_plugin:
  resource: "@DediSyliusShipmentPlugin/config/routing.yaml"
```
```yaml
# config/routes/sylius_shop.yaml

...

sylius_checkout_address:
  resource: "@DediSyliusShipmentPlugin/config/routes/shop/checkout.yaml"
  prefix: /{_locale}
  requirements:
    _locale: ^[A-Za-z]{2,4}(_([A-Za-z]{4}|[0-9]{3}))?(_([A-Za-z]{2}|[0-9]{3}))?$
```

### (Optional) - import fixtures
```yaml
# config/packages/dedi_sylius_shipment_plugin.yaml
imports:
  - { resource: "@DediSyliusShipmentPlugin/config/app/fixtures.yaml" }
```
### Customize resources

**Shipment resource**

If you haven't extended the shipment resource yet, here is what it should look like:

```php
<?php
// src/Entity/Shipment.php

declare(strict_types=1);

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Dedi\SyliusShipmentPlugin\Model\PickupPointAwareTrait;
use Dedi\SyliusShipmentPlugin\Model\ShipmentInterface;
use Sylius\Component\Core\Model\Shipment as BaseShipment;

/**
 * @ORM\Entity()
 * @ORM\Table(name="sylius_shipment")
 */
class Shipment extends BaseShipment implements ShipmentInterface
{
    use PickupPointAwareTrait;
}
```

**Shipping method resource**

If you haven't extended the shipping method resource yet, here is what it should look like:

```php
<?php
// src/Entity/ShippingMethod.php

declare(strict_types=1);

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Dedi\SyliusShipmentPlugin\Model\PickupPointProviderAwareTrait;
use Dedi\SyliusShipmentPlugin\Model\ShippingMethodInterface;
use Sylius\Component\Core\Model\ShippingMethod as BaseShippingMethod;

/**
 * @ORM\Entity()
 * @ORM\Table(name="sylius_shipping_method")
 */
class ShippingMethod extends BaseShippingMethod implements ShippingMethodInterface
{
    use PickupPointProviderAwareTrait;
}
```

**Order resource**

If you haven't extended the order resource yet, here is what it should look like:

```php
<?php
// src/Entity/ShippingMethod.php

declare(strict_types=1);

namespace App\Entity;

use Dedi\SyliusShipmentPlugin\Entity\TempAddressAwareInterface;
use Dedi\SyliusShipmentPlugin\Entity\TempAddressAwareTrait;
use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Core\Model\Order as BaseOrder;

/**
 * @ORM\Entity()
 * @ORM\Table(name="sylius_order")
 */
class Order extends BaseOrder implements TempAddressAwareInterface
{
    use TempAddressAwareTrait;
}
```

### Copy templates
```bash
mkdir -p templates/bundles/SyliusShopBundle/Checkout/SelectShipping/ 
cp vendor/dedi/sylius-shipment-plugin/templates/_choice.html.twig templates/bundles/SyliusShopBundle/Checkout/SelectShipping
```

### If you want to use cache

Cache disabled by default. To enable it, make next configuration:

```yaml
# config/packages/dedi_sylius_pickup_point.yaml
framework:
    cache:
        pools:
          dedi_sylius_shipment.provider_cache_pool:
              adapter: cache.app

dedi_sylius_shipment:
    cache:
        enabled: true
        pool: dedi_sylius_shipment.provider_cache_pool
```

### Add env variables
```dotenv
COLISSIMO_ACCOUNT_NUMBER=
COLISSIMO_PASSWORD=

DPD_KEY=

TNT_USERNAME=
TNT_PASSWORD=

GLS_LOGIN=
GLS_PASSWORD=
```

### Add script to webpack-encore
```js
// webpack.config.js
const [dediShipmentShop] = require('./vendor/dedi/sylius-shipment-plugin/webpack.config');

...

module.exports = [..., dediShipmentShop];
```
Run `yarn encore dev` to compile the script.

Configure the webpack build

```yaml
# config/packages/webpack_encore.yaml
webpack_encore:
    builds:
        dedi-shipment-shop: '%kernel.project_dir%/public/build/dedi-plugin/shipment/shop'
```

### Update database schema

```bash
bin/console doctrine:migrations:diff
bin/console doctrine:migrations:migrate
```

## Possible errors
The update of the order summary might not work if the div containing the order_summary isn't labelled with the id '#sylius-checkout-subtotal'.
You can check if it is defined in the `@SyliusShop/Checkout/_summary.html.twig` template.
