<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Searcher;

use MonsieurBiz\SyliusSearchPlugin\Model\Config\GridConfigInterface;
use MonsieurBiz\SyliusSearchPlugin\Model\Document\ResultSetInterface;

class SearcherRegistry implements SearcherRegistryInterface
{
    /** @var SearcherInterface[] */
    private iterable $searchers;

    public function __construct(iterable $searchers)
    {
        $this->searchers = $searchers;
    }

    public function search(GridConfigInterface $gridConfig): ResultSetInterface
    {
        foreach ($this->searchers as $searcher) {
            if (!$searcher->supports($gridConfig)) {
                continue;
            }

            return $searcher->search($gridConfig);
        }

        throw new \Exception(sprintf('No searcher supporting gridconfig with type %s', $gridConfig->getType()));
    }
}
