<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Model\Document\Index;

use Exception;
use MonsieurBiz\SyliusSearchPlugin\Model\Document\ResultInterface;
use MonsieurBiz\SyliusSearchPlugin\Model\Documentable\DocumentableInterface;

interface IndexerInterface
{
    public function getLocales(): array;

    public function indexAll(): void;

    /**
     * Index all document for a locale.
     *
     *
     * @throws Exception
     */
    public function indexAllByLocale(string $locale): void;

    public function indexOne(DocumentableInterface $subject): void;

    public function indexOneByLocale(ResultInterface $document, string $locale): void;

    public function removeOne(DocumentableInterface $subject): void;

    public function removeOneByLocale(ResultInterface $document, string $locale): void;
}
