<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Model\Document;

class FilterValue implements FilterValueInterface
{
    private int $count;

    public function __construct(
        private readonly string $label,
        private readonly string $slug,
        int $count,
    ) {
        $this->count = $count;
    }

    public function getSlug(): string
    {
        return $this->slug;
    }

    public function getLabel(): string
    {
        return $this->label;
    }

    public function setCount(int $count): void
    {
        $this->count = $count;
    }

    public function getCount(): int
    {
        return $this->count;
    }
}
