<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Model\Document;

class Filter implements FilterInterface
{
    public function __construct(
        private readonly string $code,
        private readonly string $label,
        private readonly int $count,
        private array $values = [],
    ) {
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function getLabel(): string
    {
        return $this->label;
    }

    public function getValues(): array
    {
        return $this->values;
    }

    public function addValue(FilterValueInterface $value): void
    {
        $this->values[] = $value;
    }

    public function removeValue(FilterValueInterface $value): void
    {
        $value = array_search($value, $this->values, true);
        if (false === $value) {
            return;
        }
        unset($this->values[$value]);
        $this->values = array_values($this->values);
    }

    public function getCount(): int
    {
        return $this->count;
    }
}
