<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Helper;

use MonsieurBiz\SyliusSearchPlugin\Exception\NotSupportedTypeException;
use MonsieurBiz\SyliusSearchPlugin\Model\Document\Result;
use MonsieurBiz\SyliusSearchPlugin\Provider\UrlParamsProvider;
use MonsieurBiz\SyliusSearchPlugin\Provider\UrlParamsProviderInterface;

class RenderDocumentUrlHelper implements RenderDocumentUrlHelperInterface
{
    public function getUrlParams(Result $document): UrlParamsProviderInterface
    {
        if ($document->getType() === 'product') {
            return new UrlParamsProvider('sylius_shop_product_show', ['slug' => $document->getSlug(), '_locale' => $document->getLocale()]);
        }

        throw new NotSupportedTypeException(sprintf('Object type "%s" not supported to get URL', $document->getType()));
    }
}
