<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Generated\Normalizer;

use ArrayObject;
use Jane\Component\JsonSchemaRuntime\Reference;
use MonsieurBiz\SyliusSearchPlugin\Generated\Model\Document;
use MonsieurBiz\SyliusSearchPlugin\Generated\Runtime\Normalizer\CheckArray;
use MonsieurBiz\SyliusSearchPlugin\Generated\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class DocumentNormalizer implements
    DenormalizerInterface,
    NormalizerInterface,
    DenormalizerAwareInterface,
    NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return $type === 'MonsieurBiz\\SyliusSearchPlugin\\Generated\\Model\\Document';
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return $data instanceof Document;
    }

    /**
     * @return mixed
     */
    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new Document();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('type', $data) && $data['type'] !== null) {
            $object->setType($data['type']);
        } elseif (\array_key_exists('type', $data) && $data['type'] === null) {
            $object->setType(null);
        }
        if (\array_key_exists('code', $data) && $data['code'] !== null) {
            $object->setCode($data['code']);
        } elseif (\array_key_exists('code', $data) && $data['code'] === null) {
            $object->setCode(null);
        }
        if (\array_key_exists('id', $data) && $data['id'] !== null) {
            $object->setId($data['id']);
        } elseif (\array_key_exists('id', $data) && $data['id'] === null) {
            $object->setId(null);
        }
        if (\array_key_exists('enabled', $data) && $data['enabled'] !== null) {
            $object->setEnabled($data['enabled']);
        } elseif (\array_key_exists('enabled', $data) && $data['enabled'] === null) {
            $object->setEnabled(null);
        }
        if (\array_key_exists('inStock', $data) && $data['inStock'] !== null) {
            $object->setInStock($data['inStock']);
        } elseif (\array_key_exists('inStock', $data) && $data['inStock'] === null) {
            $object->setInStock(null);
        }
        if (\array_key_exists('slug', $data) && $data['slug'] !== null) {
            $object->setSlug($data['slug']);
        } elseif (\array_key_exists('slug', $data) && $data['slug'] === null) {
            $object->setSlug(null);
        }
        if (\array_key_exists('image', $data) && $data['image'] !== null) {
            $object->setImage($data['image']);
        } elseif (\array_key_exists('image', $data) && $data['image'] === null) {
            $object->setImage(null);
        }
        if (\array_key_exists('channel', $data) && $data['channel'] !== null) {
            $values = [];
            foreach ($data['channel'] as $value) {
                $values[] = $value;
            }
            $object->setChannel($values);
        } elseif (\array_key_exists('channel', $data) && $data['channel'] === null) {
            $object->setChannel(null);
        }
        if (\array_key_exists('main_taxon', $data) && $data['main_taxon'] !== null) {
            $object->setMainTaxon($this->denormalizer->denormalize($data['main_taxon'], 'MonsieurBiz\\SyliusSearchPlugin\\Generated\\Model\\Taxon', 'json', $context));
        } elseif (\array_key_exists('main_taxon', $data) && $data['main_taxon'] === null) {
            $object->setMainTaxon(null);
        }
        if (\array_key_exists('taxon', $data) && $data['taxon'] !== null) {
            $values_1 = [];
            foreach ($data['taxon'] as $value_1) {
                $values_1[] = $this->denormalizer->denormalize($value_1, 'MonsieurBiz\\SyliusSearchPlugin\\Generated\\Model\\Taxon', 'json', $context);
            }
            $object->setTaxon($values_1);
        } elseif (\array_key_exists('taxon', $data) && $data['taxon'] === null) {
            $object->setTaxon(null);
        }
        if (\array_key_exists('attributes', $data) && $data['attributes'] !== null) {
            $values_2 = [];
            foreach ($data['attributes'] as $value_2) {
                $values_2[] = $this->denormalizer->denormalize($value_2, 'MonsieurBiz\\SyliusSearchPlugin\\Generated\\Model\\Attributes', 'json', $context);
            }
            $object->setAttributes($values_2);
        } elseif (\array_key_exists('attributes', $data) && $data['attributes'] === null) {
            $object->setAttributes(null);
        }
        if (\array_key_exists('price', $data) && $data['price'] !== null) {
            $values_3 = [];
            foreach ($data['price'] as $value_3) {
                $values_3[] = $this->denormalizer->denormalize($value_3, 'MonsieurBiz\\SyliusSearchPlugin\\Generated\\Model\\Price', 'json', $context);
            }
            $object->setPrice($values_3);
        } elseif (\array_key_exists('price', $data) && $data['price'] === null) {
            $object->setPrice(null);
        }
        if (\array_key_exists('original_price', $data) && $data['original_price'] !== null) {
            $values_4 = [];
            foreach ($data['original_price'] as $value_4) {
                $values_4[] = $this->denormalizer->denormalize($value_4, 'MonsieurBiz\\SyliusSearchPlugin\\Generated\\Model\\Price', 'json', $context);
            }
            $object->setOriginalPrice($values_4);
        } elseif (\array_key_exists('original_price', $data) && $data['original_price'] === null) {
            $object->setOriginalPrice(null);
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('type') && null !== $object->getType()) {
            $data['type'] = $object->getType();
        }
        if ($object->isInitialized('code') && null !== $object->getCode()) {
            $data['code'] = $object->getCode();
        }
        if ($object->isInitialized('id') && null !== $object->getId()) {
            $data['id'] = $object->getId();
        }
        if ($object->isInitialized('enabled') && null !== $object->getEnabled()) {
            $data['enabled'] = $object->getEnabled();
        }
        if ($object->isInitialized('inStock') && null !== $object->getInStock()) {
            $data['inStock'] = $object->getInStock();
        }
        if ($object->isInitialized('slug') && null !== $object->getSlug()) {
            $data['slug'] = $object->getSlug();
        }
        if ($object->isInitialized('image') && null !== $object->getImage()) {
            $data['image'] = $object->getImage();
        }
        if ($object->isInitialized('channel') && null !== $object->getChannel()) {
            $values = [];
            foreach ($object->getChannel() as $value) {
                $values[] = $value;
            }
            $data['channel'] = $values;
        }
        if ($object->isInitialized('mainTaxon') && null !== $object->getMainTaxon()) {
            $data['main_taxon'] = $this->normalizer->normalize($object->getMainTaxon(), 'json', $context);
        }
        if ($object->isInitialized('taxon') && null !== $object->getTaxon()) {
            $values_1 = [];
            foreach ($object->getTaxon() as $value_1) {
                $values_1[] = $this->normalizer->normalize($value_1, 'json', $context);
            }
            $data['taxon'] = $values_1;
        }
        if ($object->isInitialized('attributes') && null !== $object->getAttributes()) {
            $values_2 = [];
            foreach ($object->getAttributes() as $value_2) {
                $values_2[] = $this->normalizer->normalize($value_2, 'json', $context);
            }
            $data['attributes'] = $values_2;
        }
        if ($object->isInitialized('price') && null !== $object->getPrice()) {
            $values_3 = [];
            foreach ($object->getPrice() as $value_3) {
                $values_3[] = $this->normalizer->normalize($value_3, 'json', $context);
            }
            $data['price'] = $values_3;
        }
        if ($object->isInitialized('originalPrice') && null !== $object->getOriginalPrice()) {
            $values_4 = [];
            foreach ($object->getOriginalPrice() as $value_4) {
                $values_4[] = $this->normalizer->normalize($value_4, 'json', $context);
            }
            $data['original_price'] = $values_4;
        }

        return $data;
    }
}
