<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Adapter;

use MonsieurBiz\SyliusSearchPlugin\Model\Document\ResultSetInterface;
use Pagerfanta\Adapter\AdapterInterface;

class ResultSetAdapter implements AdapterInterface
{
    public function __construct(private readonly ResultSetInterface $resultSet)
    {
    }

    /**
     * @inheritdoc
     */
    public function getNbResults(): int
    {
        return $this->resultSet->getTotalHits();
    }

    /**
     * @inheritdoc
     */
    public function getSlice($offset, $length): iterable
    {
        return \array_slice($this->resultSet->getResults(), $offset, $length);
    }
}
