<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Searcher;

use MonsieurBiz\SyliusSearchPlugin\Model\Config\GridConfigInterface;
use MonsieurBiz\SyliusSearchPlugin\Model\Document\Index\SearchInterface;
use MonsieurBiz\SyliusSearchPlugin\Model\Document\ResultSetInterface;

class SearchQuerySearcher implements SearcherInterface
{
    public function __construct(
        private readonly SearchInterface $documentSearch,
    ) {
    }

    public function search(GridConfigInterface $gridConfig): ResultSetInterface
    {
        return $this->documentSearch->search($gridConfig);
    }

    public function supports(GridConfigInterface $gridConfig): bool
    {
        return $gridConfig->getType() === GridConfigInterface::SEARCH_TYPE;
    }
}
