<?php

/*
 * This file is part of Monsieur Biz' Search plugin for Sylius.
 *
 * (c) Monsieur Biz <sylius@monsieurbiz.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Model\Document;

class RangeFilter implements RangeFilterInterface
{
    public function __construct(
        private readonly string $code,
        private readonly string $label,
        private readonly string $minLabel,
        private readonly string $maxLabel,
        private readonly int $min,
        private readonly int $max,
    ) {
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function getLabel(): string
    {
        return $this->label;
    }

    public function getMinLabel(): string
    {
        return $this->minLabel;
    }

    public function getMaxLabel(): string
    {
        return $this->maxLabel;
    }

    public function getMin(): int
    {
        return $this->min;
    }

    public function getMax(): int
    {
        return $this->max;
    }
}
