<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Model\Document\Index;

use JoliCode\Elastically\Client;
use JoliCode\Elastically\IndexBuilder;
use JoliCode\Elastically\Indexer;

abstract class AbstractIndex
{
    public const DOCUMENT_INDEX_NAME = 'documents';

    /**
     * PopulateCommand constructor.
     */
    public function __construct(
        private readonly Client $client,
    ) {
    }

    /**
     * Get the client.
     */
    protected function getClient(): Client
    {
        return $this->client;
    }

    /**
     * Retrieve the index name.
     */
    protected function getIndexName(string $locale): string
    {
        return self::DOCUMENT_INDEX_NAME . '-' . strtolower($locale);
    }

    protected function getIndexBuilder(): IndexBuilder
    {
        return $this->client->getIndexBuilder();
    }

    protected function getIndexer(): Indexer
    {
        return $this->client->getIndexer();
    }
}
