<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Model\Document;

class FilterValue implements FilterValueInterface
{
    public function __construct(
        private readonly string $label,
        private readonly string $slug,
        private readonly int $count,
    ) {
    }

    public function getSlug(): string
    {
        return $this->slug;
    }

    public function getLabel(): string
    {
        return $this->label;
    }

    public function getCount(): int
    {
        return $this->count;
    }
}
