<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Helper;

interface FilterHelperInterface
{
    /**
     * Return an array with filters for query.
     */
    public function buildFilters(array $appliedFilters): array;

    /**
     * Build filter array to add in query.
     */
    public function buildFilter(string $field, array $values): array;

    /**
     * Build filter array for taxon to add in query.
     */
    public function buildTaxonFilter(array $values): array;

    /**
     * Build filter array for main taxon to add in query.
     */
    public function buildMainTaxonFilter(array $values): array;

    /**
     * Build filter array for price to add in query.
     */
    public function buildPriceFilter(int $min, int $max): array;

    /**
     * Build filter value array to add in query.
     */
    public function buildFilterValue(string $value): array;

    /**
     * Build filter value array to add in query.
     */
    public function buildTaxonFilterValue(string $value): array;

    /**
     * Build filter value array to add in query.
     */
    public function buildMainTaxonFilterValue(string $value): array;
}
