<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\EventListener;

use MonsieurBiz\SyliusSearchPlugin\Model\Document\Index\IndexerInterface;
use MonsieurBiz\SyliusSearchPlugin\Model\Documentable\DocumentableInterface;
use Symfony\Component\EventDispatcher\GenericEvent;
use Webmozart\Assert\Assert;

class DocumentListener
{
    public function __construct(private readonly IndexerInterface $documentIndexer)
    {
    }

    public function saveDocument(GenericEvent $event): void
    {
        $subject = $event->getSubject();
        Assert::isInstanceOf($subject, DocumentableInterface::class);

        $this->documentIndexer->indexOne($subject);
    }

    public function deleteDocument(GenericEvent $event): void
    {
        $subject = $event->getSubject();
        Assert::isInstanceOf($subject, DocumentableInterface::class);

        $this->documentIndexer->removeOne($subject);
    }
}
