<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Provider;

use Doctrine\ORM\EntityManagerInterface;

class DocumentRepositoryProvider implements DocumentRepositoryProviderInterface
{
    public function __construct(
        private readonly EntityManagerInterface $entityManager,
        private readonly iterable $documentableClasses,
    ) {
    }

    public function getRepositories(): array
    {
        $repositories = [];
        foreach ($this->documentableClasses as $class) {
            $repositories[] = $this->entityManager->getRepository($class);
        }

        return $repositories;
    }
}
