<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Modifier;

use MonsieurBiz\SyliusSearchPlugin\Model\Config\GridConfigInterface;
use MonsieurBiz\SyliusSearchPlugin\Model\Document\ResultSetInterface;

class CompositeResultSetModifier implements CompositeResultSetModifierInterface
{
    public function __construct(private readonly iterable $modifiers)
    {
    }

    public function modify(GridConfigInterface $gridConfig, ResultSetInterface $resultSet): void
    {
        foreach ($this->modifiers as $modifier) {
            if (!$modifier->supports($gridConfig, $resultSet)) {
                continue;
            }
            $modifier->modify($gridConfig, $resultSet);
        }
    }
}
