<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Model\Document;

use JoliCode\Elastically\Result;
use Pagerfanta\PagerfantaInterface;

interface ResultSetInterface
{
    /**
     * @return Result[]
     */
    public function getResults(): array;

    /**
     * @return FilterInterface[]
     */
    public function getFilters(): array;

    public function getTotalHits(): int;

    public function getPager(): PagerfantaInterface;

    public function getTaxonFilter(): ?FilterInterface;

    public function getMainTaxonFilter(): ?FilterInterface;

    public function getPriceFilter(): ?RangeFilterInterface;
}
