<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Model\Document;

use MonsieurBiz\SyliusSearchPlugin\Generated\Model\Attributes;
use MonsieurBiz\SyliusSearchPlugin\Generated\Model\Price;
use MonsieurBiz\SyliusSearchPlugin\Provider\UrlParamsProviderInterface;

interface ResultInterface
{
    public function getUniqId(): string;

    public function getAttribute(string $code): ?Attributes;

    public function getPriceByChannelAndCurrency(string $channelCode, string $currencyCode): ?Price;

    public function getOriginalPriceByChannelAndCurrency(string $channelCode, string $currencyCode): ?Price;

    public function getLocale(): string;

    public function getUrlParams(): UrlParamsProviderInterface;

    public function addChannel(string $channel): self;

    public function addTaxon(string $code, string $name, int $position, int $level, int $productPosition): self;

    public function addPrice(string $channel, string $currency, int $value): self;

    public function addOriginalPrice(string $channel, string $currency, int $value): self;

    public function addAttribute(string $code, string $name, array $value, string $locale, int $score): self;
}
