<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Model\Document\Index;

use MonsieurBiz\SyliusSearchPlugin\Model\Config\GridConfigInterface;
use MonsieurBiz\SyliusSearchPlugin\Model\Document\ResultSetInterface;

interface SearchInterface
{
    /**
     * Search documents for a given locale, search terms, max number items and page.
     */
    public function search(GridConfigInterface $gridConfig): ResultSetInterface;

    /**
     * Instant search documents for a given locale, query and a max number items.
     */
    public function instant(GridConfigInterface $gridConfig): ResultSetInterface;

    /**
     * Taxon search documents for a given locale, taxon code, max number items and page.
     */
    public function taxon(GridConfigInterface $gridConfig): ResultSetInterface;
}
