<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Factory\ResultSet;

use Elastica\ResultSet as ElasticaResultSet;
use MonsieurBiz\SyliusSearchPlugin\Model\Document\ResultSet;
use MonsieurBiz\SyliusSearchPlugin\Model\Document\ResultSetInterface;
use Sylius\Component\Core\Model\TaxonInterface;

class ResultSetFactory implements ResultSetFactoryInterface
{
    public function __construct(
        private readonly FiltersFactoryInterface $resultSetFiltersFactory,
        private readonly MainTaxonFilterFactoryInterface $resultSetMainTaxonFilterFactory,
        private readonly TaxonFilterFactoryInterface $resultSetTaxonFilterFactory,
        private readonly PriceFilterFactoryInterface $resultSetPriceFilterFactory,
    ) {
    }

    public function create(
        int $maxItems,
        int $page,
        ?ElasticaResultSet $resultSet = null,
        ?TaxonInterface $taxon = null,
    ): ResultSetInterface {
        $filters = $this->resultSetFiltersFactory->create($resultSet);
        $mainTaxonFilter = $this->resultSetMainTaxonFilterFactory->create($resultSet);
        $taxonFilter = $this->resultSetTaxonFilterFactory->create($resultSet, $taxon);
        $priceFilter = $this->resultSetPriceFilterFactory->create($resultSet);

        return new ResultSet(
            $maxItems,
            $page,
            $filters,
            $taxonFilter,
            $mainTaxonFilter,
            $priceFilter,
            $resultSet,
        );
    }
}
