<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Twig\Extension;

use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class FilterAppliedManually extends AbstractExtension
{
    public function __construct(private readonly array $gridConfig)
    {
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('monsieurbiz_search_filter_applied_manually', [$this, 'areFiltersAppliedManually']),
        ];
    }

    public function areFiltersAppliedManually(): bool
    {
        return $this->gridConfig['filters']['apply_manually'] ?? false;
    }
}
