<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Twig\Extension;

use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class CheckMethodExists extends AbstractExtension
{
    public function __construct(private readonly array $bundles)
    {
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('bundle_exists', [$this, 'bundleExists']),
        ];
    }

    public function bundleExists($bundle): bool
    {
        return \array_key_exists(
            $bundle,
            $this->bundles,
        );
    }
}
