<?php

declare(strict_types=1);

namespace MonsieurBiz\SyliusSearchPlugin\Model\Config;

use Sylius\Component\Core\Model\TaxonInterface;
use Symfony\Component\HttpFoundation\Request;

interface GridConfigInterface
{
    public const SEARCH_TYPE = 'search';

    public const TAXON_TYPE = 'taxon';

    public const INSTANT_TYPE = 'instant';

    public const SORT_ASC = 'asc';

    public const SORT_DESC = 'desc';

    public const FALLBACK_LIMIT = 10;

    public function init(string $type, Request $request, ?TaxonInterface $taxon = null): void;

    public function getConfig(): array;

    public function getType(): string;

    public function getLocale(): string;

    public function getQuery(): string;

    public function getPage(): int;

    /**
     * @return int[]
     */
    public function getLimits(): array;

    public function getLimit(): int;

    /**
     * @return string[]
     */
    public function getSorting(): array;

    public function haveToApplyManuallyFilters(): bool;

    public function useMainTaxonForFilter(): bool;

    /**
     * @return string[]
     */
    public function getFilters(): array;

    public function getAppliedFilters(): array;

    public function getTaxon(): ?TaxonInterface;
}
