<?php

declare(strict_types=1);

namespace Dedi\SyliusReorderPlugin\Model;

use Doctrine\Common\Collections\Collection;
use Sylius\Component\Core\Model\OrderItemInterface;

interface WrongItemsInterface
{
    /** @return Collection<int, OrderItemInterface> */
    public function getUnavailableItems(): Collection;

    public function addUnavailableItem(OrderItemInterface $unavailableItem): self;

    public function removeUnavailableItem(OrderItemInterface $unavailableItem): self;

    /** @return Collection<int, OrderItemInterface> */
    public function getPriceUpdatedItems(): Collection;

    public function addPriceUpdatedItem(OrderItemInterface $priceUpdatedItem): self;

    public function removePriceUpdatedItem(OrderItemInterface $priceUpdatedItem): self;
}
