<?php

declare(strict_types=1);

namespace Dedi\SyliusReorderPlugin\Model;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Sylius\Component\Core\Model\OrderItemInterface;

class WrongItems implements WrongItemsInterface
{
    /** @var Collection<int, OrderItemInterface> */
    private Collection $unavailableItems;

    /** @var Collection<int, OrderItemInterface> */
    private Collection $priceUpdatedItems;

    public function __construct()
    {
        $this->unavailableItems = new ArrayCollection();
        $this->priceUpdatedItems = new ArrayCollection();
    }

    /** @return Collection<int, OrderItemInterface> */
    public function getUnavailableItems(): Collection
    {
        return $this->unavailableItems;
    }

    public function addUnavailableItem(OrderItemInterface $unavailableItem): self
    {
        if (!$this->unavailableItems->contains($unavailableItem)) {
            $this->unavailableItems->add($unavailableItem);
        }

        return $this;
    }

    public function removeUnavailableItem(OrderItemInterface $unavailableItem): self
    {
        if ($this->unavailableItems->contains($unavailableItem)) {
            $this->unavailableItems->removeElement($unavailableItem);
        }

        return $this;
    }

    /** @return Collection<int, OrderItemInterface> */
    public function getPriceUpdatedItems(): Collection
    {
        return $this->priceUpdatedItems;
    }

    public function addPriceUpdatedItem(OrderItemInterface $priceUpdatedItem): self
    {
        if (!$this->priceUpdatedItems->contains($priceUpdatedItem)) {
            $this->priceUpdatedItems->add($priceUpdatedItem);
        }

        return $this;
    }

    public function removePriceUpdatedItem(OrderItemInterface $priceUpdatedItem): self
    {
        if ($this->priceUpdatedItems->contains($priceUpdatedItem)) {
            $this->priceUpdatedItems->removeElement($priceUpdatedItem);
        }

        return $this;
    }
}
