<?php

declare(strict_types=1);

namespace Dedi\SyliusReorderPlugin\Manager;

use Dedi\SyliusReorderPlugin\Model\WrongItemsInterface;
use Dedi\SyliusReorderPlugin\Processor\ReorderProcessorInterface;
use Doctrine\ORM\EntityManagerInterface;
use Sylius\Bundle\CoreBundle\Factory\OrderFactoryInterface;
use Sylius\Component\Channel\Context\ChannelContextInterface;
use Sylius\Component\Core\Model\ChannelInterface;
use Sylius\Component\Core\Model\CustomerInterface;
use Sylius\Component\Core\Model\OrderInterface;
use Sylius\Component\Core\Storage\CartStorageInterface;
use Sylius\Component\Locale\Context\LocaleContextInterface;

class ReorderManager implements ReorderManagerInterface
{
    /** @param OrderFactoryInterface<OrderInterface> $orderFactory */
    public function __construct(
        private readonly OrderFactoryInterface $orderFactory,
        private readonly ChannelContextInterface $channelContext,
        private readonly LocaleContextInterface $localeContext,
        private readonly CartStorageInterface $cartSessionStorage,
        private readonly EntityManagerInterface $entityManager,
        private readonly ReorderProcessorInterface $reorderProcessor,
    ) {
    }

    public function reorder(OrderInterface $order): WrongItemsInterface
    {
        /** @var ChannelInterface $channel */
        $channel = $this->channelContext->getChannel();
        $locale = $this->localeContext->getLocaleCode();

        $customer = $order->getCustomer();

        if (!$customer instanceof CustomerInterface) {
            throw new \Exception(sprintf('Customer not found on reordering process for order with tokenValue %s', $order->getTokenValue()));
        }

        $reorder = $this->orderFactory->createNewCart($channel, $customer, $locale);
        $wrongItems = $this->reorderProcessor->processItems($order, $reorder);
        $this->reorderProcessor->processOrderData($order, $reorder);

        $this->entityManager->persist($reorder);
        $this->entityManager->flush();

        $this->cartSessionStorage->setForChannel($channel, $reorder);

        return $wrongItems;
    }
}
