<?php

declare(strict_types=1);

namespace Dedi\SyliusReorderPlugin\ErrorHandler;

use Dedi\SyliusReorderPlugin\Helper\ProductVariantOptionValuesHelperInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Session\Session;

class ReorderItemErrorHandler implements ReorderItemErrorHandlerInterface
{
    public function __construct(
        private readonly RequestStack $requestStack,
        private readonly ProductVariantOptionValuesHelperInterface $productVariantOptionValuesHelper,
    ) {
    }

    public function handle(string $message, array $items, string $type = 'error'): void
    {
        $request = $this->requestStack->getCurrentRequest();

        if (!$request instanceof Request) {
            return;
        }

        /** @var Session $session */
        $session = $request->getSession();
        $flashBag = $session->getFlashBag();

        $fullItemNames = [];
        foreach ($items as $item) {
            $itemName = $item->getVariant()?->getProduct()?->getName();
            $itemOptionValues = $this->productVariantOptionValuesHelper->getConcatOptionValues($item->getVariant());

            $fullItemNames[] = $itemName . ' ' . $itemOptionValues;
        }

        $message = sprintf($message . ': %s', implode(', ', $fullItemNames));

        $flashBag->add($type, $message);
    }
}
