<?php

declare(strict_types=1);

namespace Dedi\SyliusReorderPlugin\DependencyInjection\Settings\Twig;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class SettingsCheckerExtension extends AbstractExtension
{
    public function __construct(private readonly SettingsProviderInterface $settingsProvider)
    {
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('dedi_sylius_reorder_check', [$this, 'check']),
            new TwigFunction('dedi_sylius_reorder_is_enabled', [$this, 'isEnabled']),
        ];
    }

    public function check(string $setting): mixed
    {
        $settings = $this->settingsProvider->provide();

        return match ($setting) {
            'enabled' => $settings->isEnabled(),
            default => throw new \InvalidArgumentException(sprintf('Unrecognized Reorder Plugin setting %s', $setting)),
        };
    }

    public function isEnabled(): bool
    {
        return (bool) $this->check('enabled');
    }
}
