<?php

declare(strict_types=1);

namespace Dedi\SyliusReorderPlugin\DependencyInjection\Settings;

use Dedi\Contracts\SyliusPluginSettings\SettingsInterface;
use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;

class SettingsProvider implements SettingsProviderInterface
{
    public function __construct(
        private readonly SettingsInterface $settings,
    ) {
    }

    public function getName(): string
    {
        return 'dedi_reorder_plugin';
    }

    public function provide(bool $default = false): SettingsInterface
    {
        return $this->settings;
    }
}
