<?php

declare(strict_types=1);

namespace Dedi\SyliusReorderPlugin\Api\ErrorHandler;

use Dedi\SyliusReorderPlugin\Helper\ProductVariantOptionValuesHelperInterface;

class ReorderItemErrorHandler implements ReorderItemErrorHandlerInterface
{
    public function __construct(private readonly ProductVariantOptionValuesHelperInterface $productVariantOptionValuesHelper)
    {
    }

    public function handle(array $items): array
    {
        $itemFullNames = [];
        foreach ($items as $item) {
            $itemName = $item->getVariant()?->getProduct()?->getName();
            $itemOptionValues = $this->productVariantOptionValuesHelper->getConcatOptionValues($item->getVariant());

            $itemFullNames[] = $itemName . ' ' . $itemOptionValues;
        }

        return $itemFullNames;
    }
}
