## Installation

Run `composer require dedi/sylius-reorder-plugin`

Add the plugin and dependency classes to your `config/bundles.php` :

```php
<?php

return [
    //..
    Dedi\SyliusReorderPlugin\DediSyliusReorderPlugin::class => ['all' => true],
    // ..
];
```

Create `dedi_sylius_reorder_plugin.yaml` file into `config/packages` folder to import the plugin's config

```yaml
# config/packages/dedi_sylius_reorder_plugin.yaml
imports:
    - { resource: "@DediSyliusReorderPlugin/Resources/config/config.yaml" }
```

### Import the routes

Create `dedi_sylius_reorder_plugin.yaml` file into `config/routes` folder to import the plugin's config

```yaml
# config/routes/dedi_sylius_reorder_plugin.yaml

...

dedi_sylius_reorder_plugin:
    resource: "@DediSyliusReorderPlugin/Resources/config/shop_routes.yaml"
```

## Import api resources

```xml
<!-- config/api_platform/Order.xml -->

<collectionOperations>
...
    <collectionOperation name="shop_reorder">
        <attribute name="path">/shop/orders/{tokenValue}/reorder</attribute>
        <attribute name="method">POST</attribute>
        <attribute name="input">false</attribute>
        <attribute name="controller">dedi_sylius_reorder_plugin.api.shop.controller.reorder</attribute>
        <attribute name="normalization_context">
            <attribute name="groups">shop:order:read</attribute>
        </attribute>
        <attribute name="denormalization_context">
            <attribute name="groups">shop:order:create</attribute>
        </attribute>
        <attribute name="openapi_context">
            <attribute name="summary">Reorder order with valid items.</attribute>
            <attribute name="parameters">
                <attribute>
                    <attribute name="name">tokenValue</attribute>
                    <attribute name="in">path</attribute>
                    <attribute name="required">true</attribute>
                    <attribute name="schema">
                        <attribute name="type">string</attribute>
                    </attribute>
                </attribute>
            </attribute>
        </attribute>
    </collectionOperation>
    
    <collectionOperation name="admin_reorder">
        <attribute name="path">/admin/orders/{tokenValue}/reorder</attribute>
        <attribute name="method">POST</attribute>
        <attribute name="input">false</attribute>
        <attribute name="controller">dedi_sylius_reorder_plugin.api.admin.controller.reorder</attribute>
        <attribute name="normalization_context">
            <attribute name="groups">shop:order:read</attribute>
        </attribute>
        <attribute name="denormalization_context">
            <attribute name="groups">admin:order:create</attribute>
        </attribute>
        <attribute name="openapi_context">
            <attribute name="summary">Reorder order with valid items.</attribute>
            <attribute name="parameters">
                <attribute>
                    <attribute name="name">tokenValue</attribute>
                    <attribute name="in">path</attribute>
                    <attribute name="required">true</attribute>
                    <attribute name="schema">
                        <attribute name="type">string</attribute>
                    </attribute>
                </attribute>
            </attribute>
        </attribute>
    </collectionOperation>
</collectionOperations>
```
