<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Specification\Quote;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Enum\QuoteInformationStateEnum;
use Sylius\Component\Order\Model\OrderInterface as BaseOrderInterface;

class IsUsableSpecification implements IsUsableSpecificationInterface
{
    public function isSatisfiedBy(OrderInterface $quote): bool
    {
        return $quote->getState() === BaseOrderInterface::STATE_CART && in_array($quote->getQuoteState(), [
            QuoteInformationStateEnum::STATE_ACCEPTED,
            QuoteInformationStateEnum::STATE_ACCEPTED_RESUPPLY,
            QuoteInformationStateEnum::STATE_VALIDATED,
        ], true);
    }
}
