<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Specification\Quote;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Enum\QuoteInformationStateEnum;

class IsAcceptedSpecification implements IsAcceptedSpecificationInterface
{
    public function isSatisfiedBy(OrderInterface $quote): bool
    {
        return in_array($quote->getQuoteState(), [
            QuoteInformationStateEnum::STATE_ACCEPTED,
            QuoteInformationStateEnum::STATE_ACCEPTED_RESUPPLY,
        ], true);
    }
}
