<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Specification\OrderItem;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Entity\OrderItemInterface;
use Dedi\SyliusQuotePlugin\Specification\Quote\IsAcceptedSpecificationInterface;
use InvalidArgumentException;

class IsQuoteItemAndAcceptedSpecification implements IsQuoteItemAndAcceptedSpecificationInterface
{
    public function __construct(
        private readonly IsQuoteItemSpecificationInterface $isQuoteItemSpecification,
        private readonly IsAcceptedSpecificationInterface $isAcceptedSpecification,
    ) {
    }

    public function isSatisfiedBy(OrderItemInterface $orderItem): bool
    {
        if (!$this->isQuoteItemSpecification->isSatisfiedBy($orderItem)) {
            return false;
        }

        $order = $orderItem->getOrder();

        if (!$order instanceof OrderInterface) {
            throw new InvalidArgumentException(sprintf(
                'Expected an instance of "%s", got "%s"',
                OrderInterface::class,
                get_class($order),
            ));
        }

        return $this->isAcceptedSpecification->isSatisfiedBy($order);
    }
}
