<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Service;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Enum\QuoteTransitionEnum;
use Dedi\SyliusQuotePlugin\Specification\Order\IsQuoteSpecificationInterface;
use Doctrine\ORM\EntityManagerInterface;
use SM\Factory\Factory;

class QuoteValidatedStateApplicator
{
    public function __construct(
        private readonly Factory $stateMachineFactory,
        private readonly EntityManagerInterface $entityManager,
        private readonly IsQuoteSpecificationInterface $isQuoteSpecification,
    ) {
    }

    public function apply(OrderInterface $order): void
    {
        if (!$this->isQuoteSpecification->isSatisfiedBy($order)) {
            return;
        }

        $stateMachine = $this->stateMachineFactory->get($order, QuoteTransitionEnum::GRAPH);

        $stateMachine->apply(QuoteTransitionEnum::TRANSITIONS_VALIDATE);

        $this->entityManager->persist($order);
    }
}
