<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Service;

use DateTimeInterface;
use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Enum\QuoteTransitionEnum;
use Dedi\SyliusQuotePlugin\Repository\QuoteRepositoryInterface;
use Doctrine\ORM\EntityManagerInterface;
use SM\Factory\Factory;

class ExpiredQuoteRemover implements ExpiredQuoteRemoverInterface
{
    private readonly QuoteRepositoryInterface $quoteRepository;

    private readonly EntityManagerInterface $entityManager;

    private readonly Factory $stateMachineFactory;

    private readonly int $batchSize;

    public function __construct(
        QuoteRepositoryInterface $quoteRepository,
        EntityManagerInterface $entityManager,
        Factory $stateMachineFactory,
        int $batchSize,
    ) {
        $this->quoteRepository = $quoteRepository;
        $this->entityManager = $entityManager;
        $this->stateMachineFactory = $stateMachineFactory;
        $this->batchSize = $batchSize;
    }

    /**
     * @inheritdoc
     */
    public function deleteExpiredQuotes(DateTimeInterface $dateTime): void
    {
        $count = 0;
        $expiredQuotes = $this->quoteRepository->findExpiredQuotes($dateTime);

        /** @var OrderInterface $expiredQuote */
        foreach ($expiredQuotes as $expiredQuote) {
            $stateMachine = $this->stateMachineFactory->get($expiredQuote, QuoteTransitionEnum::GRAPH);
            $stateMachine->apply(QuoteTransitionEnum::TRANSITIONS_EXPIRE);

            $this->entityManager->persist($expiredQuote);

            if ((++$count % $this->batchSize) === 0) {
                $this->entityManager->flush();
                $this->entityManager->clear();
            }
        }

        $this->entityManager->flush();
    }
}
