export default class QuoteTotalRecalculator {
    constructor({
        formId
    }) {
        const totalInput = document.getElementById(formId);
        const autoTotalInput = document.getElementById('auto-total');

        if (autoTotalInput.checked) {
            totalInput.parentNode.classList.add('disabled');
            recalculateTotal();
        }

        function recalculateTotal() {
            let total = 0;
            document.querySelectorAll('input.item-unit-price').forEach((input) => {
                const quantity = document.getElementById(input.dataset.quantityId).value;
                const priceInCents = Math.round(parseFloat(input.value.replace(',', '.') || '0') * 100);
                total += (priceInCents * parseInt(quantity || '1'));
            });

            if (!isNaN(total)) {
                totalInput.value = (total / 100).toFixed(2);
            }
        }

        autoTotalInput.addEventListener('change', function () {
            totalInput.parentNode.classList.toggle('disabled');
            if (this.checked) {
                recalculateTotal();
            }
        });

        document.addEventListener('input', function (e) {
            if (e.target && e.target.classList.contains('item-unit-price') || e.target.classList.contains('item-quantity')) {
                if (autoTotalInput.checked) {
                    recalculateTotal();
                }
            }
        });

        document.addEventListener('click', function (e) {
            if (e.target && e.target.classList.contains('item-delete')) {
                if (autoTotalInput.checked) {
                    setTimeout(recalculateTotal, 300);
                }
            }
        });
    }
}
