<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Repository;

use Sylius\Component\Core\Model\ChannelInterface;
use Sylius\Component\Core\Model\CustomerInterface;
use Sylius\Component\Core\Model\OrderInterface;
use Sylius\Component\Core\Repository\OrderRepositoryInterface;
use Sylius\Component\Resource\Repository\RepositoryInterface;

interface QuoteRepositoryInterface extends RepositoryInterface, OrderRepositoryInterface
{
    public function findLatestNotEmptyQuoteCartByChannelAndCustomer(ChannelInterface $channel, CustomerInterface $customer): ?OrderInterface;

    public function findExpiredQuotes(\DateTimeInterface $expirationDate): iterable;
}
