<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Entity;

use Doctrine\Common\Collections\Collection;
use Sylius\Component\Core\Model\OrderInterface as BaseOrderInterface;

interface OrderInterface extends BaseOrderInterface
{
    public function initializeQuoteOrders(): void;

    public function getQuoteInformation(): ?QuoteInformationInterface;

    public function setQuoteInformation(?QuoteInformationInterface $quoteInformation = null): self;

    public function getQuote(): ?self;

    public function setQuote(?\Tests\Dedi\SyliusQuotePlugin\Application\src\Entity\OrderInterface $quote): self;

    public function getOrders(): Collection;

    public function hasOrder(self $order): bool;

    public function addOrder(self $order): self;

    public function removeOrder(self $order): self;

    public function getQuoteState(): string;

    public function setQuoteState(string $quoteState): self;
}
