<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Entity;

use DateTime;
use DateTimeInterface;
use Sylius\Component\Core\Model\AdminUserInterface;

class InternalComment implements InternalCommentInterface
{
    protected ?int $id = null;

    protected ?QuoteInformationInterface $quoteInformation = null;

    protected ?AdminUserInterface $user;

    protected ?string $comment = null;

    protected ?DateTimeInterface $createdAt = null;

    protected ?DateTimeInterface $updatedAt = null;

    public function __construct()
    {
        $this->createdAt = new DateTime();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getQuoteInformation(): ?QuoteInformationInterface
    {
        return $this->quoteInformation;
    }

    public function setQuoteInformation(?QuoteInformationInterface $quoteInformation): self
    {
        $this->quoteInformation = $quoteInformation;

        return $this;
    }

    public function getUser(): ?AdminUserInterface
    {
        return $this->user;
    }

    public function setUser(?AdminUserInterface $user): self
    {
        $this->user = $user;

        return $this;
    }

    public function getCreatedAt(): ?DateTimeInterface
    {
        return $this->createdAt;
    }

    public function setCreatedAt(?DateTimeInterface $createdAt): self
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function getUpdatedAt(): ?DateTimeInterface
    {
        return $this->updatedAt;
    }

    public function setUpdatedAt(?DateTimeInterface $updatedAt): self
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    public function getComment(): ?string
    {
        return $this->comment;
    }

    public function setComment(?string $comment): self
    {
        $this->comment = $comment;

        return $this;
    }
}
