<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\DependencyInjection;

use Dedi\SyliusQuotePlugin\Controller\QuoteInformationController;
use Dedi\SyliusQuotePlugin\Entity\InternalComment;
use Dedi\SyliusQuotePlugin\Entity\InternalCommentInterface;
use Dedi\SyliusQuotePlugin\Entity\QuoteInformation;
use Dedi\SyliusQuotePlugin\Entity\QuoteInformationInterface;
use Dedi\SyliusQuotePlugin\Entity\QuoteItemInformation;
use Dedi\SyliusQuotePlugin\Entity\QuoteItemInformationInterface;
use Dedi\SyliusQuotePlugin\Form\Type\QuoteInternalCommentType;
use Dedi\SyliusQuotePlugin\Repository\QuoteInformationRepository;
use Sylius\Bundle\ResourceBundle\Controller\ResourceController;
use Sylius\Bundle\ResourceBundle\SyliusResourceBundle;
use Sylius\Component\Resource\Factory\Factory;
use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

final class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('dedi_sylius_quote');
        $rootNode = $treeBuilder->getRootNode();

        $rootNode
            ->addDefaultsIfNotSet()
            ->children()
                ->scalarNode('driver')->defaultValue(SyliusResourceBundle::DRIVER_DOCTRINE_ORM)->end()
                ->booleanNode('anonymous_quote_allowed')->defaultValue(false)->end()
                ->booleanNode('cart_edit_allowed')->defaultValue(false)->end()
                ->booleanNode('enabled')->defaultValue(false)->end()
            ->end()
        ;

        $this->addResourcesSection($rootNode);

        return $treeBuilder;
    }

    private function addResourcesSection(ArrayNodeDefinition $nodeDefinition): void
    {
        $nodeDefinition
            ->children()
                ->arrayNode('resources')
                    ->addDefaultsIfNotSet()
                        ->children()
                        ->arrayNode('quote_information')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->variableNode('options')->end()
                                ->arrayNode('classes')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->scalarNode('model')->defaultValue(QuoteInformation::class)->cannotBeEmpty()->end()
                                        ->scalarNode('interface')->defaultValue(QuoteInformationInterface::class)->cannotBeEmpty()->end()
                                        ->scalarNode('factory')->defaultValue(Factory::class)->cannotBeEmpty()->end()
                                        ->scalarNode('repository')->defaultValue(QuoteInformationRepository::class)->cannotBeEmpty()->end()
                                        ->scalarNode('controller')->defaultValue(QuoteInformationController::class)->cannotBeEmpty()->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('quote_item_information')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->variableNode('options')->end()
                                ->arrayNode('classes')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->scalarNode('model')->defaultValue(QuoteItemInformation::class)->cannotBeEmpty()->end()
                                        ->scalarNode('interface')->defaultValue(QuoteItemInformationInterface::class)->cannotBeEmpty()->end()
                                        ->scalarNode('factory')->defaultValue(Factory::class)->cannotBeEmpty()->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('quote_internal_comment')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->variableNode('options')->end()
                                ->arrayNode('classes')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->scalarNode('model')->defaultValue(InternalComment::class)->cannotBeEmpty()->end()
                                        ->scalarNode('interface')->defaultValue(InternalCommentInterface::class)->cannotBeEmpty()->end()
                                        ->scalarNode('factory')->defaultValue(Factory::class)->cannotBeEmpty()->end()
                                        ->scalarNode('controller')->defaultValue(ResourceController::class)->cannotBeEmpty()->end()
                                        ->scalarNode('form')->defaultValue(QuoteInternalCommentType::class)->cannotBeEmpty()->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ->end()
        ;
    }
}
