<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Action;

use Sylius\Component\Channel\Repository\ChannelRepositoryInterface;
use Sylius\Component\Core\Model\ChannelInterface;
use Sylius\Component\Core\Model\ChannelPricingInterface;
use Sylius\Component\Core\Model\ProductVariantInterface;
use Sylius\Component\Core\Repository\ProductVariantRepositoryInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Webmozart\Assert\Assert;

class FetchVariantChannelPricingAction
{
    private readonly ProductVariantRepositoryInterface $productVariantRepository;

    private readonly ChannelRepositoryInterface $channelRepository;

    public function __construct(
        ProductVariantRepositoryInterface $productVariantRepository,
        ChannelRepositoryInterface $channelRepository,
    ) {
        $this->productVariantRepository = $productVariantRepository;
        $this->channelRepository = $channelRepository;
    }

    public function __invoke(Request $request): Response
    {
        /** @var ProductVariantInterface $variant */
        $variant = $this->productVariantRepository->find($request->query->getInt('variantId'));
        /** @var ChannelInterface $channel */
        $channel = $this->channelRepository->findOneByCode($request->query->get('channelCode'));

        $channelPricing = $variant->getChannelPricingForChannel($channel);

        Assert::isInstanceOf($channelPricing, ChannelPricingInterface::class);

        return new JsonResponse([
            'price' => $channelPricing->getPrice() / 100,
        ]);
    }
}
