<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Voter;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Specification\Quote\IsAcceptedSpecificationInterface;
use Dedi\SyliusQuotePlugin\Specification\Quote\IsUsableSpecificationInterface;
use Sylius\Component\Core\Model\AdminUserInterface;
use Sylius\Component\Core\Model\ShopUserInterface;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Core\Authorization\Voter\Voter;
use Symfony\Component\Security\Core\Security;

class QuoteVoter extends Voter
{
    final public const IS_QUOTE_USABLE = 'IS_QUOTE_USABLE';

    final public const IS_QUOTE_ACCEPTED = 'IS_QUOTE_ACCEPTED';

    public function __construct(
        private readonly Security $security,
        private readonly IsUsableSpecificationInterface $isUsableSpecification,
        private readonly IsAcceptedSpecificationInterface $isAcceptedSpecification,
    ) {
    }

    protected function supports(string $attribute, $subject): bool
    {
        return in_array($attribute, [self::IS_QUOTE_USABLE, self::IS_QUOTE_ACCEPTED], true) && $subject instanceof OrderInterface;
    }

    protected function voteOnAttribute(string $attribute, mixed $subject, TokenInterface $token): bool
    {
        $user = $this->security->getUser();
        if ($user instanceof AdminUserInterface) {
            return true;
        }

        if (!$user instanceof ShopUserInterface || $user->getCustomer() !== $subject->getCustomer()) {
            return false;
        }

        switch ($attribute) {
            case self::IS_QUOTE_USABLE:
                return $this->isUsableSpecification->isSatisfiedBy($subject);
            case self::IS_QUOTE_ACCEPTED:
                return $this->isAcceptedSpecification->isSatisfiedBy($subject);
            default:
                return true;
        }
    }
}
