<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Storage;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Sylius\Component\Core\Model\ChannelInterface;

interface QuoteCartStorageInterface
{
    public function hasForChannel(ChannelInterface $channel): bool;

    public function getForChannel(ChannelInterface $channel): ?OrderInterface;

    public function setForChannel(ChannelInterface $channel, OrderInterface $quote): void;

    public function removeForChannel(ChannelInterface $channel): void;
}
