<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Specification\Quote;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Enum\QuoteInformationStateEnum;
use Sylius\Component\Core\Model\OrderInterface as BaseOrderInterface;

class IsCartSpecification implements IsCartSpecificationInterface
{
    public function isSatisfiedBy(OrderInterface $order): bool
    {
        return $order->getQuoteState() === QuoteInformationStateEnum::STATE_CART && $order->getState() === BaseOrderInterface::STATE_CART;
    }
}
