<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Specification\OrderItem;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Entity\OrderItemInterface;
use Dedi\SyliusQuotePlugin\Specification\Order\IsQuoteSpecificationInterface;

class IsQuoteItemSpecification implements IsQuoteItemSpecificationInterface
{
    public function __construct(private readonly IsQuoteSpecificationInterface $isQuoteSpecification)
    {
    }

    public function isSatisfiedBy(OrderItemInterface $orderItem): bool
    {
        /** @var ?OrderInterface $order */
        $order = $orderItem->getOrder();

        if (null === $order) {
            return false;
        }

        return $this->isQuoteSpecification->isSatisfiedBy($order);
    }
}
