<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Specification\OrderItem;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Entity\OrderItemInterface;
use Dedi\SyliusQuotePlugin\Specification\Order\IsFromQuoteSpecificationInterface as OrderIsFromQuoteSpecification;

class IsFromQuoteSpecification implements IsFromQuoteSpecificationInterface
{
    public function __construct(private readonly OrderIsFromQuoteSpecification $orderIsFromQuoteSpecification)
    {
    }

    public function isSatisfiedBy(OrderItemInterface $orderItem): bool
    {
        /** @var ?OrderInterface $order */
        $order = $orderItem->getOrder();

        if (null === $order) {
            return false;
        }

        return $this->orderIsFromQuoteSpecification->isSatisfiedBy($order);
    }
}
