<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Service;

class QuoteConfiguration implements QuoteConfigurationInterface
{
    private bool $anonymousQuoteAllowed;

    private bool $cartFromQuoteEditAllowed;

    public function __construct(
        bool $anonymousQuoteAllowed,
        bool $cartFromQuoteEditAllowed,
    ) {
        $this->anonymousQuoteAllowed = $anonymousQuoteAllowed;
        $this->cartFromQuoteEditAllowed = $cartFromQuoteEditAllowed;
    }

    public function isAnonymousQuoteAllowed(): bool
    {
        return $this->anonymousQuoteAllowed;
    }

    public function isCartFromQuoteEditAllowed(): bool
    {
        return $this->cartFromQuoteEditAllowed;
    }
}
